function [lossFunctionValue,aicValue] = evaluateLossFunctionValue(netz,object,kk)
% This function is used several times at different positions of the
% 'findInputCombinations' method. Depending on the variable netz and on the
% availability of validation data the lossFunctionValue is calculated
% differently
%
% [lossFunctionValue,aicValue] = evaluateLossFunctionValue(netz,object,kk)
%
% INPUTS
%
% netz:         sensitivityAnalysis object, that has lastly be trained with
%               the current input combination.
%
% object:       sensitivityAnalysis object, that will contain the results
%               of the input selection. This object contains more
%               information in contrast to 'netz' such as originalInput.
%
% kk:           EITHER the iteration number (in case of the bruteForce
%               search method) OR logical combination vector determing the
%               currently investigated input combination

% The third input argument can either be the input combination that is
% currently investigated or (in case of the bruteForce search strategy) the
% number of the loop.
if size(kk,2) == 1
    combinationVector = object.combinationMatrix(kk,:);
else
    combinationVector = kk;
end

if isempty(netz)
    % In case of no input while investigating the x-space,
    % there is no trained model. In this case set the model
    % outputs all to zero (another version could be the mean
    % value of all outputs).
%     yHatVali = zeros(size(object.input,1),1);
    yHatVali = repmat(mean(object.output),size(object.output,1),1); %--> Mean of all output values
    lossFunctionValue = object.calcGlobalLossFunction(object.output,yHatVali);
elseif isempty(object.validationInput)
    % Calculate AIC value
    lossFunctionValue = calcPenaltyLossFunction(netz);
    %                 [~, ~, ~, ~, lossFunctionValues(2,kk)] = calcPenaltyLossFunction(netz);
elseif strcmp(object.space2investigate,'x')
    % Determine the error on validation data
    yHatVali = netz.calculateModelOutput(object.validationInput(:,combinationVector));
    lossFunctionValue = netz.calcGlobalLossFunction(object.validationOutput,yHatVali);
else
    % This condition will be true, if the z-input space is
    % investigated and validation data is available
    yHatVali = netz.calculateModelOutput(object.validationInput);
    lossFunctionValue = netz.calcGlobalLossFunction(object.validationOutput,yHatVali);
end

% Has to be replaced... Work in progress...
aicValue = lossFunctionValue;

end