function plotCorrelation(obj)

schrift = 15;
plotAxis = gca;

hCorrPlot = [];
hCorrLegend = {};

minAx = min(min(obj.output),min(obj.outputModel));
maxAx = max(max(obj.output),max(obj.outputModel));

% plot y over yhat
hCorrPlot(end+1) = plot(obj.output,obj.outputModel,'k.','markersize',12);
hCorrLegend{end+1} = 'Training Data';
hold all

% plot validation Data
if ~isempty(obj.validationInput) && ~isempty(obj.validationOutput)
    validationOutputModel = obj.calculateModelOutput(obj.validationInput);
    hCorrPlot(end+1) = plot(obj.validationOutput,validationOutputModel,'g.','markersize',12);
    hCorrLegend{end+1} = 'Validation Data';
end

% plot test data
if ~isempty(obj.testInput) && ~isempty(obj.testOutput)
    testOutputModel = obj.calculateModelOutput(obj.testInput);
    hCorrPlot(end+1) = plot(obj.testOutput,testOutputModel,'r.','markersize',12);
    hCorrLegend{end+1} = 'Test Data';
end

legend(hCorrPlot,hCorrLegend,'Location','NorthWest')

% plot 45 line
line([minAx maxAx],[minAx maxAx],'color','k','LineStyle','--')

axis([minAx maxAx minAx maxAx])
title('correlation plot of model','fontsize',schrift,'fontName','Times New Roman')
%set(hPlot,'fontsize',schrift,'fontName','Times New Roman'); %zlabel('y','fontsize',schrift,'fontName','Times New Roman')

xlabel('training output','fontsize',schrift,'fontName','Times New Roman'); 
ylabel('model output','fontsize',schrift,'fontName','Times New Roman')

end