function plotLossFunction(obj, options)
% PLOTLOSSFUNCTION is used to make nice plot of the global and penalty loss
% function of a given model
%
%   plotLossFunction(options)
%
%
% INPUTS:
%   options     (struct)
%
%
% LMNtool - Local Model Network Toolbox
% Tobias Ebert, 12-December-2011
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles


warning('this plot function is not finished and subject to change')

%% check options
if exist('options','var') && isfield(options,'plotAxis')
    plotAxis = options.plotAxis;
else
    plotAxis = gca;
end


%% Plausibility check
if isempty(obj.history)
    warning('history is empty, nothing will be plotted')
    return
end

if ~iscell(obj.history.leafModelIter)
    warning('leafModelIter is not a cellarray. No plot will be generated')
    return
end

%% plot all iterations

% get number of local models
% nLM = cellfun(@(x) sum(x),obj.history.leafModelIter);
nLM = obj.history.currentNumberOfParameters;

% generate global loff function plot
subplot(2,1,1)
hplot = plot(nLM,obj.history.globalLossFunction);
set(hplot(end),'Marker','o')
legendString{1} = 'training data';

if ~isempty(obj.history.validationDataLossFunction)
    % plot validation data
    hold all
    hplot(end+1) = plot(nLM,obj.history.validationDataLossFunction);
    set(hplot(end),'Marker','o')
    legendString{end+1} = 'validation data';
end

if ~isempty(obj.history.testDataLossFunction)
    % plot test data
    hold all
    hplot(end+1) = plot(nLM,obj.history.testDataLossFunction);
    set(hplot(end),'Marker','o')
    legendString{end+1} = 'test data';
end

legend(hplot,legendString)

%set(gca,'YScale','log')
xlabel('number of parameters')
ylabel(obj.lossFunctionGlobal)

% generate penalty loss function plot
subplot(2,1,2)
hpenalty = plot(nLM,obj.history.penaltyLossFunction);
set(hpenalty,'Marker','o')
%set(gca,'YScale','log')
xlabel('number of parameters')
ylabel('penalty loss function')

end

