function [J JAll] = calcLocalCVLossFunction(obj,LM)


Phi = obj.phi(:,obj.leafModels);
N = size(Phi,1);
numberOfOutputs = 1;

currLM = find( LM==find(obj.leafModels) );

% Cut data points such that only the points corresponding to the investingated
% local model are left.
[~, columnIdx] = max(Phi,[],2);
% idxLMPoints = (columnIdx==currLM);
idxLMPoints = true(N,1);

phi = obj.phi(:,LM);
X   = obj.xRegressor;
dataWeighting = obj.dataWeighting;
y = obj.output;
yModel = obj.outputModel;


% w = estimateParametersLocal(obj, obj.xRegressor(idxLMPoints,:), obj.output(idxLMPoints), obj.phi(idxLMPoints,LM), inf, obj.dataWeighting(idxLMPoints));

LMPoints = find(idxLMPoints);



% figure(1);
% plot(X(:,2),y,'x')
% hold on
% plot(X(LMPoints,2),y(LMPoints),'ro')




J = 0;

JAll = zeros(N,1);


% Perform leave-one-out cross validation
for k = 1:sum(idxLMPoints)

    idxCV = true(N,1);
    idxCV(LMPoints(k)) = false;

    phiCV = phi(idxCV);
    XCV   = X(idxCV,:);
    dataWeightingCV = dataWeighting(idxCV,:);
    yCV   = y(idxCV,:);
    uTest = X(~idxCV,:);

    % Define vectors/matrices for local estimation
    r = sqrt(phiCV.*dataWeightingCV);             % Weighting vector for data
    rMat = r(:,ones(size(XCV,2),1));        % Generate an N x nx matrix [r r ... r]
    xRegressorWeighted = XCV.*rMat;          % Weighted regression matrix
    rMat = r(:,ones(numberOfOutputs,1));            % Generate an N x q matrix [r r ... r]
    outputWeighted = yCV.*rMat;                  % Weighted output matrix

    % LS estimation, generate an nx x q parameter matrix using Q-R-factorization for fast computation
    wCV = xRegressorWeighted \ outputWeighted;
%     wCV = pinv(xRegressorWeighted)*outputWeighted;


    % Test model on uTest
    testOutput = yModel(~idxCV) + phi(~idxCV)*( (uTest * wCV) - yModel(~idxCV) );

%     J = J + phi(~idxCV)*abs(y(~idxCV)-testOutput);

    JAll(~idxCV) = phi(~idxCV)*abs(y(~idxCV)-testOutput);
    %     plot(uTest(2),y(~idxCV),'kx','markersize',14,'linewidth',2)
    %     plot(uTest(2),testOutput,'ro','markersize',14,'linewidth',2)

%     % Weight with model output confidence
%     alpha = 0.05;
% %     alpha = 0.0000034;
%     [covYhat varianz] = modCalcCI(X,uTest,yModel-y,phi,alpha);
% %     [covYhat varianz] = modCalcCI(XCV,uTest,yModel(idxCV)-y(idxCV),phiCV,alpha);
% %     [covYhat varianz] = modCalcCI(xRegressorWeighted,uTest,yModel(idxCV)-y(idxCV),phiCV,alpha);
%     JAll(~idxCV) = JAll(~idxCV)/(covYhat+eps);%*varianz;
% %     JAll(~idxCV) = JAll(~idxCV)/(varianz+eps)*covYhat;

end

% Weight loss with number of all samples
J = sum(JAll)/N;


end






%%


function [delta variance] = modCalcCI(XReg,inputReg,errorValue,Q,alpha,CIofFunctionOrData,sig2Known)
% Support function to calculate Confidence Intervalls without the need of
% the statistics toolbox for the regressors on inputReg
%
% delta = modCalcCI(XReg,inputReg,error)
%
%   input:
%   XReg        regressors for the model
%   inputReg    regressors of the interval where the confidence interval is
%               unknown
%   error       vector of the estimated Errors
%
%
% delta = modCalcCI(XReg,inputReg,error,Q,alpha)
%   Q           weighting matrix
%   alpha       significance, default is 0.05, equals CI=95%
%
% Tobias Ebert, 19-March-2010
% Institut fr Mess- und Regelungstechnik, Universitt Siegen, Germany
% Copyright (c) 2010 by Tobias Ebert
%--------------------------------------------------------------------------

% 05.07.10 replaced variable error by errorValue

% BE SURE xREG is not weighted!

[N n] = size(XReg);

% catch errors
if size(inputReg,2)==1 || size(XReg,2)==1 %isvector(inputReg) || isvector(XReg)
    warning('mod:CalcCI:regressorOrder','regressor is of 0th order')
end

if ~(size(XReg,2) == size(inputReg,2))
    error('mod:CalcCI:regressorNotEqual','N1 ~= N2, dimension of regressors must be the same');
end


% reduce matrices if possible
% if nargin >= 4 && isvector(Q) && any(Q==0)% if a weighting matrix is given
% %     keyboard; % there might be an error here
%     iud = Q>0;% Index of usable data
%     sdelta = spalloc(size(Q,1),1,sum(iud));
%     XReg = XReg(iud,:);
%     inputReg = inputReg(iud,:);
%     errorValue = errorValue(iud,:);
%     Q = Q(iud);
% end

if nargin < 4  || isempty(Q) % if no weighting matrix Q is given
    Q = speye(N);
end
if nargin < 5 || isempty(alpha) 
    alpha = 0.05; % equals a confidence interval of 95%
end
if nargin < 6 || isempty(CIofFunctionOrData) 
    CIofFunctionOrData = 'data';
end

% if Q is given as an vector
if isvector(Q)
    Q = diag(Q);
    %Q =spdiags(Q,0,length(Q),length(Q));
end

% normalise Q
%Q = Q/sum(sum(Q)) * sum(sum(Q>0));

% estimate variance of the error if not given
%sig2 = error' * error / (N-n);
if ~exist('sig2Known','var')
    if sum(sum(Q))-n > 0
        %sig2 = sum(error(diag(Q)>1e-16).^2) / (sum(sum(Q))-n);
        variance = sum(errorValue.^2.*diag(Q)) / (sum(sum(Q))-n);
        %sig2 = sum(error.^2) / (sum(sum(Q))-n);
    else
        variance = inf;%sum(error(diag(Q)>0).^2);
    end
else
    variance = sig2Known;
end
    

ThetaQ = pinv(XReg'*Q*XReg);

%--------------------------------------------------------------------------
% calculate the covariance matrix for the estimated output
%--------------------------------------------------------------------------
%covYhat = sparse(size(XReg,1),size(XReg,1));
switch CIofFunctionOrData
    case 'function'
        % calculate the CI of the estimated function. This means, if more
        % datapoints are added, the CI becomes smaler, because the
        % parameters are estimated more accurate.
        covYhat = variance * ( 0+ inputReg * ThetaQ * XReg' * Q.^2 * XReg * ThetaQ * inputReg' );
    case 'data'
        % calculate the CI with 1-alpha % of the datapoint within it. This
        % means with more datapoints added to the estimation, the CI won't
        % become smaler, but the percentage of datapoint outside of the CI
        % will tend towards alpha
        covYhat = variance * ( 1+ inputReg * ThetaQ * XReg' * Q.^2 * XReg * ThetaQ * inputReg' );
end

sdcovYhat = sqrt(diag(covYhat));

%delta = tinv(1-alpha/2,N-n)*sqrt(diag(covYhat));
if sum(sum(Q)) > n
    % delta = tinv(1-alpha/2,sum(sum(Q))-n)*sdcovYhat;
    
    if ((sum(sum(Q))-n) == floor(sum(sum(Q))-n)) && ((sum(sum(Q))-n) <= 100) && (alpha==0.05)
        tinvFactor = savedtinv(sum(sum(Q))-n); % calculating tinv takes long, so we calculated it before
    else
        tinvFactor = tinv(1-alpha/2,sum(sum(Q))-n);
    end
    delta = tinvFactor*sdcovYhat;
else
%     warning('mod:CalcCI','Sum of weighting Matrix to low or not enough datapoints')
    delta = inf*sdcovYhat;%tinv(1-alpha/2,1)*sqrt(diag(covYhat));
end


if exist('iud','var') % if there was a reduction of the matrices to improve calculation speed
    sdelta(iud) = delta;
    delta = sdelta;
end

end

function precalculated = savedtinv(i)

precalculated = [6.31375151467504;2.91998558035372;2.35336343480182;2.13184678632665;2.01504837333302;1.94318028051530;1.89457860509001;1.85954803753090;1.83311293265624;1.81246112281168;1.79588481870404;1.78228755564932;1.77093339598687;1.76131013577489;1.75305035569257;1.74588367627625;1.73960672607507;1.73406360661754;1.72913281152137;1.72471824292079;1.72074290281188;1.71714437438024;1.71387152774705;1.71088207990943;1.70814076125190;1.70561791975927;1.70328844572213;1.70113093426593;1.69912702653350;1.69726088659396;1.69551878254586;1.69388874838371;1.69236030903034;1.69092425518684;1.68957245778025;1.68829771411681;1.68709361959624;1.68595446016668;1.68487512171124;1.68385101333566;1.68287800213264;1.68195235746761;1.68107070320248;1.68022997657210;1.67942739265242;1.67866041355682;1.67792672164188;1.67722419612431;1.67655089261687;1.67590502516311;1.67528495042494;1.67468915372601;1.67411623670312;1.67356490635215;1.67303396528983;1.67252230307574;1.67202888846086;1.67155276245487;1.67109303210395;1.67064886490450;1.67021948377386;1.66980416251201;1.66940222170680;1.66901302502402;1.66863597584758;1.66827051422777;1.66791611410739;1.66757228079655;1.66723854866869;1.66691447905593;1.66659965832850;1.66629369613155;1.66599622377136;1.66570689273419;1.66542537332245;1.66515135340474;1.66488453725812;1.66462464450669;1.66437140913639;1.66412457858979;1.66388391292258;1.66364918402916;1.66342017491883;1.66319667904891;1.66297849970193;1.66276544940909;1.66255734941289;1.66235402916690;1.66215532586964;1.66196108403013;1.66177115506173;1.66158539690332;1.66140367366477;1.66122585529658;1.66105181727715;1.66088144032495;1.66071461012302;1.66055121706572;1.66039115601680;1.66023432608559;1.66008063041176;1.65992997597031;1.65978227338028;1.65963743672914;1.65949538340679;1.65935603394735;1.65921931188114;1.65908514359565;1.65895345820328;1.65882418741379;1.65869726542157;1.65857262878818;1.65845021633986;1.65832996906775;1.65821183003117;1.65809574426877;1.65798165871340;1.65786952211071;1.65775928494291;1.65765089935524;1.65754431908739;1.65743949940730;1.65733639704879;1.65723497015098;1.65713517820320;1.65703698199046;1.65694034354230;1.65684522608153;1.65675159398162;1.65665941271962;1.65656864883329;1.65647926988228;1.65639124440929;1.65630454190087;1.65621913275600;1.65613498824788;1.65605208049632;1.65597038243365;1.65588986777643;1.65581051099690;1.65573228729693;1.65565517258092;1.65557914343171;1.65550417708760;1.65543025141763;1.65535734490213;1.65528543660927;1.65521450617894;1.65514453379786;1.65507550018707;1.65500738658033;1.65494017470762;1.65487384678177;1.65480838547624;1.65474377391994;1.65467999567153;1.65461703471524;1.65455487543936;1.65449350263103;1.65443290145750;1.65437305745681;1.65431395652690;1.65425558491369;1.65419792919951;1.65414097629620;1.65408471342859;1.65402912813292;1.65397420824394;1.65391994188198;1.65386631745228;1.65381332363264;1.65376094936174;1.65370918384102;1.65365801651591;1.65360743707938;1.65355743545575;1.65350800180154;1.65345912649249;1.65341080012344;1.65336301349729;1.65331575762286;1.65326902370515;1.65322280314577;1.65317708753132;1.65313186863211;1.65308713839639;1.65304288894658;1.65299911257170;1.65295580172599;1.65291294902239;1.65287054723030;1.65282858927017;1.65278706820916;1.65274597725929;1.65270530977167;1.65266505923311;1.65262521926541;1.65258578361820;1.65254674616663;1.65250810091059;1.65246984197010;1.65243196357965;1.65239446009153;1.65235732596587;1.65232055577263;1.65228414418827;1.65224808599383;1.65221237606572;1.65217700938636;1.65214198102834;1.65210728616132;1.65207292004335;1.65203887802668;1.65200515554618;1.65197174812495;1.65193865136631;1.65190586095943;1.65187337266883;1.65184118233985;1.65180928588981;1.65177767931441;1.65174635867969;1.65171532012247;1.65168455984994;1.65165407413517;1.65162385931915;1.65159391180735;1.65156422806659;1.65153480463044;1.65150563808714;1.65147672508674;1.65144806234063;1.65141964661046;1.65139147471830;1.65136354353860;1.65133584999920;1.65130839108097;1.65128116381428;1.65125416527931;1.65122739260761;1.65120084297491;1.65117451360706;1.65114840177392;1.65112250478972;1.65109682001482;1.65107134485132;1.65104607674296;1.65102101317630;1.65099615167749;1.65097148981285;1.65094702518734;1.65092275544415;1.65089867826403;1.65087479136553;1.65085109249865;1.65082757945414;1.65080425005589;1.65078110215802;1.65075813365326;1.65073534246278;1.65071272654153;1.65069028387525;1.65066801248188;1.65064591040594;1.65062397572640;1.65060220654755;1.65058060100245;1.65055915725489;1.65053787349239;1.65051674793250;1.65049577881850;1.65047496441540;1.65045430302174;1.65043379295420;1.65041343255614;1.65039322019593;1.65037315426568;1.65035323317742;1.65033345537208;1.65031381930548;1.65029432346219;1.65027496634437;1.65025574647660;1.65023666240503;1.65021771269570;1.65019889593219;1.65018021072291;1.65016165569324;1.65014322948532;1.65012493076334;1.65010675820981;1.65008871052295;1.65007078642063;1.65005298463681;1.65003530392613;1.65001774305558;1.65000030081170;1.64998297599547;1.64996576742671;1.64994867393720;1.64993169437885;1.64991482761500;1.64989807252448;1.64988142800459;1.64986489296198;1.64984846632051;1.64983214701937;1.64981593400787;1.64979982625130;1.64978382272921;1.64976792243155;1.64975212436439;1.64973642754349;1.64972083099881;1.64970533377464;1.64968993492150;1.64967463351024;1.64965942861527;1.64964431932629;1.64962930474845;1.64961438398798;1.64959955617449;1.64958482043749;1.64957017592272;1.64955562178875;1.64954115719831;1.64952678132895;1.64951249336686;1.64949829250614;1.64948417795720;1.64947014893106;1.64945620465486;1.64944234436272;1.64942856729740;1.64941487271320;1.64940125987076;1.64938772803914;1.64937427649961;1.64936090453743;1.64934761145084;1.64933439654191;1.64932125912417;1.64930819851817;1.64929521405024;1.64928230505968;1.64926947088783;1.64925671088731;1.64924402441774;1.64923141084134;1.64921886953723;1.64920639988273;1.64919400126540;1.64918167308203;1.64916941473241;1.64915722562557;1.64914510517472;1.64913305280518;1.64912106794174;1.64910915001864;1.64909729847921;1.64908551276870;1.64907379234107;1.64906213665260;1.64905054517196;1.64903901736757;1.64902755271894;1.64901615070432;1.64900481081677;1.64899353254563;1.64898231539188;1.64897115886085;1.64896006245992;1.64894902570748;1.64893804812245;1.64892712922857;1.64891626855916;1.64890546564774;1.64889472003712;1.64888403126884;1.64887339889649;1.64886282247409;1.64885230156117;1.64884183571947;1.64883142452133;1.64882106753824;1.64881076434810;1.64880051453255;1.64879031767611;1.64878017337529;1.64877008121710;1.64876004080708;1.64875005174403;1.64874011363694;1.64873022609614;1.64872038873798;1.64871060117890;1.64870086304494;1.64869117396017;1.64868153355510;1.64867194146492;1.64866239732782;1.64865290078256;1.64864345147721;1.64863404905758;1.64862469317573;1.64861538349046;1.64860611965412;1.64859690133635;1.64858772819644;1.64857859990546;1.64856951613637;1.64856047656262;1.64855148086069;1.64854252871845;1.64853361981172;1.64852475383397;1.64851593047376;1.64850714942741;1.64849841038469;1.64848971305103;1.64848105712460;1.64847244231533;1.64846386832446;1.64845533486745;1.64844684165644;1.64843838840659;1.64842997483643;1.64842160066654;1.64841326562538;1.64840496943350;1.64839671182205;1.64838849252352;1.64838031127070;1.64837216780179;1.64836406185283;1.64835599316758;1.64834796148805;1.64833996656181;1.64833200813622;1.64832408595987;1.64831619979170;1.64830834937879;1.64830053448499;1.64829275486661;1.64828501028595;1.64827730050793;1.64826962529510;1.64826198442112;1.64825437765083;1.64824680475850;1.64823926551894;1.64823175970768;1.64822428710245;1.64821684748443;1.64820944063448;1.64820206633703;1.64819472437710;1.64818741454711;1.64818013662856;1.64817289041955;1.64816567571097;1.64815849229704;1.64815133997684;1.64814421854631;1.64813712780733;1.64813006756256;1.64812303761298;1.64811603776719;1.64810906782992;1.64810212761128;1.64809521692019;1.64808833557257;1.64808148337572;1.64807466014859;1.64806786570790;1.64806109987248;1.64805436245842;1.64804765328918;1.64804097218884;1.64803431898207;1.64802769349042;1.64802109554423;1.64801452497181;1.64800798160136;1.64800146526908;1.64799497580314;1.64798851303761;1.64798207681046;1.64797566695745;1.64796928331710;1.64796292572755;1.64795659403141;1.64795028807165;1.64794400768843;1.64793775272794;1.64793152303912;1.64792531846555;1.64791913885514;1.64791298405985;1.64790685392954;1.64790074831555;1.64789466707445;1.64788861005476;1.64788257711753;1.64787656811799;1.64787058291125;1.64786462135788;1.64785868332047;1.64785276865623;1.64784687722955;1.64784100890360;1.64783516354281;1.64782934101135;1.64782354117777;1.64781776390834;1.64781200907160;1.64780627653786;1.64780056617656;1.64779487786074;1.64778921146247;1.64778356685427;1.64777794391244;1.64777234251150;1.64776676252655;1.64776120383757;1.64775566632381;1.64775014985816;1.64774465432830;1.64773917961019;1.64773372559025;1.64772829214871;1.64772287916676;1.64771748652994;1.64771211413130;1.64770676184861;1.64770142957168;1.64769611718948;1.64769082458937;1.64768555166024;1.64768029829676;1.64767506439050;1.64766984982311;1.64766465450136;1.64765947830944;1.64765432114694;1.64764918290803;1.64764406348656;1.64763896278108;1.64763388069103;1.64762881710975;1.64762377194050;1.64761874508163;1.64761373643251;1.64760874589757;1.64760377337642;1.64759881877178;1.64759388198647;1.64758896292650;1.64758406149198;1.64757917759804;1.64757431113899;1.64756946203013;1.64756463017469;1.64755981547988;1.64755501785976;1.64755023721716;1.64754547347062;1.64754072651831;1.64753599628090;1.64753128266946;1.64752658559642;1.64752190497133;1.64751724070784;1.64751259272648;1.64750796093559;1.64750334525506;1.64749874559935;1.64749416188315;1.64748959402729;1.64748504194754;1.64748050556345;1.64747598479115;1.64747147955407;1.64746698977086;1.64746251536012;1.64745805624707;1.64745361234959;1.64744918359069;1.64744476989444;1.64744037118468;1.64743598738280;1.64743161841542;1.64742726420312;1.64742292467827;1.64741859976164;1.64741428938117;1.64740999346365;1.64740571193449;1.64740144472229;1.64739719175967;1.64739295297190;1.64738872828654;1.64738451763319;1.64738032094707;1.64737613815478;1.64737196918788;1.64736781397963;1.64736367246054;1.64735954456103;1.64735543021816;1.64735132936412;1.64734724193003;1.64734316785432;1.64733910706661;1.64733505950716;1.64733102510749;1.64732700380604;1.64732299553769;1.64731900023947;1.64731501784997;1.64731104830312;1.64730709154064;1.64730314750057;1.64729921611803;1.64729529733758;1.64729139109192;1.64728749732933;1.64728361598337;1.64727974699525;1.64727589031048;1.64727204586838;1.64726821360770;1.64726439347395;1.64726058540908;1.64725678935897;1.64725300525900;1.64724923305541;1.64724547270188;1.64724172412820;1.64723798728946;1.64723426212580;1.64723054858480;1.64722684660900;1.64722315615028;1.64721947714855;1.64721580955403;1.64721215331382;1.64720850837435;1.64720487468185;1.64720125218679;1.64719764083738;1.64719404058301;1.64719045136671;1.64718687314751;1.64718330586608;1.64717974947694;1.64717620393009;1.64717266917434;1.64716914516277;1.64716563184319;1.64716212916948;1.64715863709209;1.64715515556544;1.64715168453938;1.64714822396946;1.64714477380153;1.64714133399498;1.64713790450226;1.64713448527623;1.64713107627052;1.64712767744403;1.64712428874227;1.64712091012566;1.64711754154906;1.64711418296904;1.64711083433637;1.64710749560933;1.64710416674802;1.64710084770386;1.64709753843492;1.64709423889724;1.64709094905117;1.64708766884992;1.64708439825266;1.64708113721704;1.64707788570450;1.64707464366964;1.64707141107051;1.64706818786902;1.64706497402230;1.64706176948991;1.64705857423035;1.64705538820927;1.64705221137885;1.64704904370116;1.64704588514040;1.64704273565434;1.64703959520555;1.64703646375375;1.64703334125922;1.64703022768891;1.64702712299898;1.64702402715293;1.64702094011406;1.64701786184172;1.64701479230548;1.64701173146372;1.64700867927569;1.64700563571188;1.64700260073232;1.64699957430097;1.64699655638284;1.64699354694238;1.64699054593879;1.64698755334124;1.64698456911717;1.64698159322467;1.64697862563462;1.64697566630904;1.64697271521333;1.64696977231665;1.64696683758005;1.64696391097484;1.64696099246181;1.64695808201453;1.64695517959061;1.64695228516394;1.64694939869792;1.64694652016189;1.64694364952313;1.64694078674540;1.64693793180288;1.64693508465972;1.64693224528113;1.64692941364265;1.64692658970543;1.64692377344240;1.64692096482167;1.64691816380965;1.64691537037922;1.64691258449920;1.64690980613538;1.64690703526087;1.64690427184427;1.64690151585195;1.64689876726424;1.64689602603876;1.64689329215444;1.64689056558100;1.64688784628598;1.64688513423915;1.64688242941846;1.64687973178952;1.64687704132278;1.64687435799259;1.64687168177157;1.64686901262578;1.64686635053685;1.64686369547041;1.64686104739608;1.64685840629575;1.64685577212888;1.64685314487454;1.64685052451375;1.64684791100963;1.64684530433365;1.64684270446475;1.64684011137559;1.64683752503874;1.64683494542696;1.64683237251418;1.64682980627596;1.64682724668851;1.64682469371692;1.64682214734337;1.64681960754232;1.64681707428772;1.64681454755210;1.64681202730793;1.64680951353657;1.64680700621370;1.64680450530538;1.64680201079319;1.64679952265544;1.64679704086249;1.64679456539073;1.64679209621783;1.64678963332093;1.64678717667288;1.64678472625323;1.64678228204059;1.64677984399679;1.64677741211386;1.64677498636835;1.64677256673154;1.64677015317658;1.64676774568352;1.64676534423757;1.64676294881237;1.64676055937308;1.64675817591132;1.64675579840270;1.64675342681980;1.64675106114326;1.64674870135210;1.64674634742372;1.64674399933319;1.64674165706430;1.64673932059183;1.64673698989456;1.64673466494954;1.64673234574315;1.64673003224438;1.64672772443683;1.64672542229897;1.64672312581123;1.64672083495115;1.64671854970053;1.64671627002967;1.64671399593332;1.64671172737899;1.64670946435500;1.64670720683075;1.64670495479660;1.64670270822436;1.64670046709914;1.64669823140359;1.64669600111012;1.64669377620685;1.64669155666200;1.64668934247770;1.64668713361448;1.64668493006112;1.64668273179692;1.64668053880780;1.64667835107043;1.64667616856242;1.64667399127231;1.64667181917978;1.64666965225988;1.64666749049895;1.64666533388689;1.64666318238731;1.64666103599750;1.64665889468673;1.64665675845020;1.64665462726330;1.64665250110375;1.64665037996753;1.64664826381528;1.64664615264811;1.64664404644399;1.64664194518373;1.64663984884510;1.64663775741699;1.64663567088349;1.64663358922403;1.64663151241953;1.64662944045438;1.64662737331876;1.64662531099049;1.64662325344550;1.64662120067955;1.64661915266658;1.64661710939678;1.64661507085071;1.64661303700932;1.64661100786411;1.64660898338939;1.64660696357808;1.64660494840412;1.64660293786229;1.64660093193062;1.64659893059024;1.64659693383362;1.64659494163866;1.64659295399069;1.64659097087675;1.64658899227957;1.64658701818367;1.64658504857745;1.64658308343549;1.64658112275229;1.64657916651264;1.64657721469374;1.64657526728705;1.64657332427864;1.64657138564720;1.64656945138404;1.64656752147130;1.64656559589605;1.64656367464035;1.64656175769727;1.64655984503919;1.64655793666560;1.64655603255544;1.64655413269315;1.64655223706859;1.64655034566540;1.64654845846885;1.64654657546406;1.64654469664002;1.64654282198578;1.64654095147850;1.64653908511135;1.64653722286397;1.64653536473416;1.64653351069431;1.64653166074519;1.64652981486234;1.64652797303386;1.64652613525064;1.64652430150048;1.64652247176408;1.64652064602924;1.64651882428873;1.64651700652071;1.64651519272043;1.64651338287259;1.64651157696129;1.64650977497222;1.64650797690254;1.64650618273323;1.64650439244496;1.64650260603218;1.64650082348536;1.64649904478690;1.64649726992529;1.64649549889312;1.64649373166532;1.64649196824303;1.64649020860771;1.64648845274348;1.64648670065271;1.64648495230661;1.64648320769894;1.64648146682228;1.64647972965993;1.64647799620024;1.64647626643638;1.64647454035063;1.64647281793045;1.64647109917038;1.64646938405223;1.64646767256922;1.64646596470784;1.64646426045822;1.64646255980586;1.64646086274396;1.64645916925343;1.64645747933080;1.64645579296452;1.64645411013492;1.64645243084019;1.64645075506664;1.64644908280064;1.64644741403464;1.64644574875147;1.64644408694797;1.64644242861164;1.64644077372415;1.64643912228779;1.64643747427934;1.64643582969616;1.64643418852237;1.64643255075072;1.64643091637282;1.64642928536915;1.64642765773905;1.64642603346690;1.64642441254408;1.64642279495915;1.64642118069784;1.64641956976493;1.64641796213275;1.64641635779880;1.64641475674812;1.64641315898106;1.64641156448360;1.64640997323540;1.64640838523560;1.64640680047912;1.64640521894267;1.64640364062871;1.64640206552365;1.64640049361184;1.64639892488956;1.64639735934917;1.64639579697518;1.64639423775826;1.64639268169123;1.64639112877119;1.64638957897171;1.64638803230253;1.64638648874598;1.64638494828095;1.64638341091661;1.64638187663503;1.64638034542677;1.64637881728546;];
precalculated = precalculated(i);

%this function may be inproved by saving those tinvs which are calculated on the fly

end


