classdef scaleData
    % SCALEDATA is a class for data scaling
    %
    % PROPERTIES:
    %
    % method    (String)    Method how the data is scaled. Options are:
    %                       'unitVarianceScaling'
    %                       'orthogonalScaling'
    %                       'boxcox_[value]' bsp boxcox_0.5
    %                       (Default = 'unitVarianceScaling')
    %
    % parameter (Struct)    parameters of the data scaling method
    %
    % SYMBOLS AND ABBREVIATIONS
    %
    % LM:  Local model
    % p:   Number of inputs (physical inputs)
    % q:   Number of outputs
    % N:   Number of data samples
    % M:   Number of LMs
    % nx:  Number of regressors (x)
    % nz:  Number of regressors (z)
    
    % LMNtool - Local Model Network Toolbox
    % Tobias Ebert, 24-April-2012
    % Institute of Mechanics & Automatic Control, University of Siegen, Germany
    % Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles
    
    properties
        method = 'unitVarianceScaling' % data scaling method
        parameter = []; % parameters of the data scaling method
    end
    
    methods
        % constructor
        function obj = scaleData(varargin)
            if nargin == 1
                obj.method = varargin{1};
            end
        end
    end
    
end

