function reposGUIelements(hList,mainHandle)
% Programm zum Umpositionieren und zur Groessenaenderung von programmierten
% GUI's. Dazu wird ein Vektor benoetigt mit folgenden Eigenschaften:
%
% hList:      [Anzahl figure-handles] x 1: figure-handles
% mainHandle: 1 x 1 Handle: main figure
%
% Sind alle Objekte umpositioniert bzw. deren Größen geändert, sind in dem
% gewählten mat-file alle Positionen und Größen in einer Structure
% gespeichert. Diese heißt "positionen" enthält soviel Felder wie Elemente
% in der Variablen hList enthalten waren. Der Feldname korrespondiert mit
% den entsprechenden Tag-Namen der Elemente in der hList.
%
% Beispiel: hList(1) enthält handle zu einem "Pushbutton" Element, dessen
% Tag-Name "Button1" lautet. Im mat-File gibt es dann in der Structure
% "positionen" ein Feld mit Namen "Button1", d.h. man kann nach dem Laden
% des mat-files wie folgt auf die "neue" Position des Elements wie folgt
% zugreifen:
%
% positionen.Button1 = 1x4 Vektor


%% get Names for the handle-objects included in hList
nameTags = cell(length(hList),1);
for ii = 1:length(hList)
    nameTags{ii,1} = get(hList(ii),'Tag');
end

%% definitions
screen   = get(0,'screensize');
width    = round(screen(3)*0.2);
height   = round(screen(4)*0.6);

% make sure the buttons and the listbox fit into the main figure
if width < 300
    width = 300;
end
if height < 110
    height = 110;
end

% position main figure
positionfh = [(screen(3)-width)/2 (screen(4)-height)/2 ...
    width height];

% positions of the components
phbearbeiten = [20 20 100 30];
phspeichern  = [140 20 100 30];
phinfo       = [260 20 30 30];
whLbox       = round(width*0.9);
hhLbox       = round((height-70)*0.95);
phLbox       = [20 70 whLbox hhLbox];


%% Figure, non visible at first
fh = figure('Visible','off',...
    'Position',positionfh,...
    'Toolbar','none',...
    'MenuBar','none');

%% gui components
hLbox = uicontrol('Style','listbox',...
    'Position',phLbox,...
    'String',nameTags,...
    'Callback',@tiggle_hobject);

hbearbeiten = uicontrol('Style','Pushbutton',...
    'Position',phbearbeiten,...
    'String','Change',...
    'Callback',@change_hObject);

hspeichern = uicontrol('Style','Pushbutton',...
    'Position',phspeichern,...
    'String','Save',...
    'Callback',@save_newPos);

hinfo = uicontrol('Style','Pushbutton',...
    'Position',phinfo,...
    'String','i',...
    'Callback',@info_button);


%% make figure visible
set(fh,'Visible','on');
set([fh,hLbox,hbearbeiten,hspeichern,hinfo],'Units','normalized');


%% functions to change the position of components from other figures

    function tiggle_hobject(hObject,eventdata)
        % function to move the selected component from the listbox to let
        % the user know, which element he (or she) actually selected
        size(eventdata);
        lbElement = get(hObject,'Value');
        elementPos = get(hList(lbElement),'Position');
        set(hList(lbElement),'Position',elementPos-5)
        pause(0.5)
        set(hList(lbElement),'Position',elementPos)
    end

    function change_hObject(hObject,eventdata)
        % select and move component to be changed.
        size(eventdata);
        size(hObject);
        plotedit(mainHandle,'on');
    end

    function save_newPos(hObject,eventdata)
        % Save all sizes and positions of all components to a mat-file,
        % which name and location on the hard-disk can be selected by the
        % user
        size(hObject);
        size(eventdata);
        plotedit(mainHandle,'off');
        positionen = struct;
        [matfile,location] = uiputfile('*.mat');
        for jj = 1:length(hList)
            tmpPos = get(hList(jj),'Position');
            eval(['positionen.',nameTags{jj,1},'= [',...
                num2str(tmpPos),'];']);
        end
        save([location,matfile],'positionen');
        size(positionen);
        close(fh);
    end

    function info_button(hObject,eventdata)
        % display how to use this gui
        size(hObject);
        size(eventdata);
        msgbox(['1. Click on change to move and resize components ',...
            '2. To save all positions and sizes of the components ',...
            'click on the save button.'],...
            'How to use me (this GUI)',...
            'help');
    end

end