% DEMOHILOMOTDOECLASS demonstrates the functioning of the HILOMOTDOE toolbox for a nonlinear
% static regression example.

% HILOMOTDOE Nonlinear System Identification Toolbox for Design of Experiments
% Benjamin Hartmann, 25-November-2011
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2011 by Prof. Dr.-Ing. Oliver Nelles

clear all
clear
close all
clc
clear java

% Add path of HILOMOT class files
% restoredefaultpath
% hilomotDirectory = fileparts(which(mfilename));
% addpath(hilomotDirectory);

% Initialize hilomot object
design = hilomotDoE;

% User defined options
design.numberOfInitialPoints = 3;
design.smoothnessQuery = 1.5;

% Option for implementation of variable increments
% design.variableIncrements = [0 0.02 1; 0 0.03 1];
global example fehler

fehler = [];

% Example selection 1, ..., 13
% example = 13;
example = 18;

% example = 11;
% example = 1;
% example = 'hyperbelGauss';

% Standard deviation of white noise
noiseLevel = 0.05;


[u1g u2g] = meshgrid(linspace(0,1,30), linspace(0,1,30));
u1Plot = u1g(:);
u2Plot = u2g(:);
yPlot = demoFunctions([u1Plot u2Plot],example);
yPlotNoise = yPlot + noiseLevel*randn(size(u1Plot,1),1);

h = figure(123);
set(h,'Position',[522 446 700 650])
surf(u1g,u2g,reshape(yPlotNoise,30,30))
set(gca,'fontsize',13)
title('Process that has to be measured','fontsize',13)
xlabel('u_1','fontsize',13)
ylabel('u_2','fontsize',13)
zlabel('y','fontsize',13)
pause%(1)
close



% Generate candidate data set
load demoCandidatePoints.mat
design.candidatePoints = candidatePoints;
u1 = design.candidatePoints(:,1);
u2 = design.candidatePoints(:,2);
NCand = size(u1,1);

% Simulate measurement with example function:
y = demoFunctions([u1 u2], example) + noiseLevel*randn(size(u1,1),1);

% Initialization phase
[query] = design.DoEUpdate;

% Simulate measurement
yQuery = demoFunctions(query, example) + noiseLevel*randn(size(query,1),1);

% Generate data set: data = [u_ist y_ist u_soll]
design.inputTarget   = [design.inputTarget; query];
design.inputMeasured = [design.inputMeasured; query];
design.output        = [design.output; yQuery];

% Enable Active Learning procedure
design.flagSpaceFilling = false;


h = figure(123);
set(h,'Position',[522 446 700 650])


% profile on

% Active learning phase
for k = 1:50
    
    % Perform active learning
    [query] = design.DoEUpdate;
    
    % Simulate measurement
    yQuery = demoFunctions(query, example) + noiseLevel*randn(size(query,1),1);
    
    % Generate data set: data = [u_ist y_ist u_soll]
    design.inputTarget   = [design.inputTarget; query];
    design.inputMeasured = [design.inputMeasured; query];
    design.output        = [design.output; yQuery];
    
    %     % Example for failed measurement
    %     if k == 11 || k == 23
    %         fprintf('\n\n -> Simulation of failed measurement! \n\n')
    %         pause(0.1)
    %         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %         % Important note for user, if measurement failed:
    %         % Store query as target input. Store measured input and
    %         % output as NaN!
    %         design.inputTarget(end,:)   = query;
    %         design.inputMeasured(end,:) = [NaN NaN];
    %         design.output(end)          = NaN;
    %         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %     end
    
    %     figure(23)
    %     plot(design.inputMeasured(:,1),design.inputMeasured(:,2),'k.','markersize',11,'linewidth',2); hold on
    %     plot(query(:,1),query(:,2),'ro','markersize',11,'linewidth',2); hold off
    %     set(gca,'fontsize',13,'XTick',[0 0.5 1],'YTick',[0 0.5 1])
    %     title('Selected measurement points (black) and new query point (red)','fontsize',13)
    %     xlabel('u_1','fontsize',13)
    %     ylabel('u_2','fontsize',13)
    %     axis([0 1 0 1])
    
end

% profile viewer

% toc
% Plots

% close all

% figure(24)
% surf(u1g,u2g,reshape(yPlot,30,30))
% alpha(0.3); hold on
% plot3(design.inputMeasured(:,1),design.inputMeasured(:,2),design.output,'ro','markersize',11,'linewidth',2)
% set(gca,'fontsize',13)
% title('Process and selected measurement points','fontsize',13)
% xlabel('u_1','fontsize',13)
% ylabel('u_2','fontsize',13)
% zlabel('y','fontsize',13)
%
figure(25)
contour(u1g,u2g,reshape(yPlot,30,30))
hold on
plot3(design.inputMeasured(:,1),design.inputMeasured(:,2),design.output,'ro','markersize',11,'linewidth',2)
set(gca,'fontsize',13,'XTick',[0 0.5 1],'YTick',[0 0.5 1])
title('Process and selected measurement points','fontsize',13)
xlabel('u_1','fontsize',13)
ylabel('u_2','fontsize',13)


% clearvars -except design
% clearvars -except fehler

%
% LMN = hilomot;
% LMN.xRegressorDegree = 1;
% LMN.scaleInput = [];
% LMN.input = design.inputMeasured;
% LMN.output = design.output;
% LMN.LOOCV = true;
% LMN.optLOOCV = true;
%
% LMN = LMN.train(false);
%
%
% [u1g u2g] = meshgrid(linspace(0,1,30), linspace(0,1,30));
% u1Plot = u1g(:);
% u2Plot = u2g(:);
%
%
% y = demoFunctions([u1Plot u2Plot],example);
% yM = LMN.calculateModelOutput([u1Plot u2Plot]);
%
% h = figure(123);
% set(h,'Position',[522 446 700 650])
%
% clf
% % subplot(3,1,[1 2])
% hold on
%
% hProzess = mesh(u1g,u2g,reshape(y,30,30));
% h = surf(u1g,u2g,reshape(yM,30,30));
% % colormap hot
% set(hProzess,'edgeColor','k','faceColor','none')
% set(h,'edgeAlpha',0.3,'faceAlpha',0.3)
% % axis([0 1 0 1 -0.25 1.25])
% grid on
%
% plot3(LMN.input(:,1),LMN.input(:,2),LMN.output,'kx','linewidth',2,'markersize',12)
% %     plot3(query(1),query(2),demoFunctions(query, example),'ro','linewidth',2,'markersize',12)
% if example == 13
%     plot3(0.3,0.5,1,'bx','linewidth',2,'markersize',14)
% end
% if example == 18
%     plot3(0.3,0.5,1,'bx','linewidth',2,'markersize',14)
%     plot3(1,1,1,'bx','linewidth',2,'markersize',14)
% end
% contour(u1g,u2g,reshape(yM,30,30))
%  view(3)
%
% hold off
% set(gca,'fontsize',13)
% xlabel('u_1','fontsize',13)
% ylabel('u_2','fontsize',13)
% zlabel('y','fontsize',13)
%







