% lolimotDemo1 Demo 1. Static process with 1 input and 1 output

% LoLiMoT - Nonlinear System Identification Toolbox
% Torsten Fischer, 20-October-2011
% Institute of Mechanics & Automatic Control, University of Siegen, Germany
% Copyright (c) 2012 by Prof. Dr.-Ing. Oliver Nelles


% Training
lolimotObject = lolimot;                   % Generate an empty net and data set structure

u = linspace(0,1,300)';
lolimotObject.input = u;
lolimotObject.output = 1 ./ (0.1 + u);

lolimotObject.maxNumberOfLM = 6;                            % Termination criterion for maximal number of LLMs
lolimotObject.minError = 0.005;                             % Termination criterion for minimal error
lolimotObject.kStepPrediction = 0;                          % Static model
lolimotObject.smoothness = 0.8;                             % Less overlap between the validity functions
lolimotObject.complexityPenalty = 1;                        % Increase penalty for model complexity
lolimotObject.history.displayMode = true;                   % display information

lolimotObject.LOOCV = true;

% Train net
lolimotObject = lolimotObject.train;

% Find best performance/complexity trade-off
[~, idxBest] = min(lolimotObject.history.penaltyLossFunction);
lolimotObject.leafModels = lolimotObject.history.leafModelIter{idxBest};


% Generalization
uG = linspace(-0.05,1.2,270)';
yG = 1 ./ (0.1 + uG);

% Simulate net
yGModel = calculateModelOutput(lolimotObject, uG, yG);
JG = calcGlobalLossFunction(lolimotObject ,yG, yGModel);

figure
lolimotObject.plotModel

figure
lolimotObject.plotPartition