function[sys,x0,str,ts]=FMDAnim(t,x,u,flag,T)

switch flag,

  %%%%%%%%%%%%%%%%%%
  % Initialization %
  %%%%%%%%%%%%%%%%%%
  case 0,
    [sys,x0,str,ts]=mdlInitializeSizes(T);

  %%%%%%%%%%
  % Update %
  %%%%%%%%%%
  case 2,
    sys=mdlUpdate(t,x,u);

  %%%%%%%%%%%
  % Outputs %
  %%%%%%%%%%%
  case 3,
    sys=mdlOutputs(t,x,u);

  %%%%%%%%%%%%%%%%%%%%%%%
  % GetTimeOfNextVarHit %
  %%%%%%%%%%%%%%%%%%%%%%%
  case 4,
    sys=mdlGetTimeOfNextVarHit(t,x,u);

  %%%%%%%%%%%%%
  % Terminate %
  %%%%%%%%%%%%%
  case 9,
    sys=mdlTerminate(t,x,u);
  
  %%%%%%%%%%%%%%%%%%%
  % Unhandled flags %
  %%%%%%%%%%%%%%%%%%%
  case 1,
    sys = [];

  %%%%%%%%%%%%%%%%%%%%
  % Unexpected flags %
  %%%%%%%%%%%%%%%%%%%%
  otherwise
    error(['Unhandled flag = ',num2str(flag)]);

end

% end sfuntmpl

%
%=============================================================================
% mdlInitializeSizes
% Return the sizes, initial conditions, and sample times for the S-function.
%=============================================================================
%
function [sys,x0,str,ts]=mdlInitializeSizes(T)

%
% call simsizes for a sizes structure, fill it in and convert it to a
% sizes array
%
sizes = simsizes;

sizes.NumContStates  = 0;
sizes.NumDiscStates  = 1;
sizes.NumOutputs     = 0;
sizes.NumInputs      = 3;
sizes.DirFeedthrough = 0;
sizes.NumSampleTimes = 1;     % at least one sample time is needed

sys = simsizes(sizes);

%
% initialize the initial conditions
%
x0  = [0];

%
% str is always an empty matrix
%
str = [];

%
% initialize the array of sample times
%
ts  = [T 0];      % variable sample time


h=figure(1);
axis([-2.5 5.5 -4 4]);
axis square;
grid off;
cla;
set(h,'DoubleBuffer','on');



% end mdlInitializeSizes

%
%=============================================================================
% mdlUpdate
% Handle discrete state updates, sample time hits, and major time step
% requirements.
%=============================================================================
%
function sys=mdlUpdate(t,x,u)

sys = [];
cla;

%----------------------------------
%System in der Ausgangsposition
%----------------------------------
%Masse
h=line([0 0],[0 0]);
set(h,'LineWidth',[1],'MarkerSize',40,'Color',[0.8 0.8 0.8],'Marker','.');

%Dmpfer
h=line([0 0.5],[0 0]);
set(h,'LineWidth',[2],'Color',[0.8 0.8 0.8]);
h=line([0.5 0.5],[-0.3 0.3]);
set(h,'LineWidth',[2],'Color',[0.8 0.8 0.8]);
h=line([2.6 0.5],[-0.3 -0.3]);
set(h,'LineWidth',[2],'Color',[0.8 0.8 0.8]);
h=line([2.6 0.5],[0.3 0.3]);
set(h,'LineWidth',[2],'Color',[0.8 0.8 0.8]);
h=line([2.5 5],[0 0]);
set(h,'LineWidth',[2],'Color',[0.8 0.8 0.8]);
h=line([2.5 2.5],[-0.25 0.25]);
set(h,'LineWidth',[2],'Color',[0.8 0.8 0.8]);
   
%Feder
h=line([-2 -2],[0.5 -0.5]);
set(h,'LineWidth',[2],'Color',[0.8 0.8 0.8]);
h=line([-2 -2+0.2],[0 0]);
set(h,'LineWidth',[2],'Color',[0.8 0.8 0.8]);
h=line([u(1) u(1)-0.2],[0 0]);
set(h,'LineWidth',[2],'Color',[0.8 0.8 0.8]);
Federgaenge=10;
for i=1:Federgaenge
    d=1.6/Federgaenge;
    if i==1
        h=line([-1.8 -1.8+d],[0 0.25]);
        set(h,'LineWidth',[2],'Color',[0.8 0.8 0.8]);
    elseif i==Federgaenge
        h=line([-1.8+(i-1)*d -1.8+i*d],[(-1)^i*0.25 0]);
        set(h,'LineWidth',[2],'Color',[0.8 0.8 0.8]);
    else
        h=line([-1.8+(i-1)*d -1.8+i*d],[(-1)^i*0.25 (-1)^(i+1)*0.25]);
        set(h,'LineWidth',[2],'Color',[0.8 0.8 0.8]);
    end            
end

%Wand
h=line([5 5],[0.5 -0.5]);
set(h,'LineWidth',[5],'Color',[0.8 0.8 0.8]);

%----------------------------------
%Bewegtes System 
%----------------------------------
%Masse
h=line([u(1) u(1)],[0 0]);
set(h,'LineWidth',[1],'MarkerSize',40,'Color',[0 0 0],'Marker','.');

%Dmpfer
h=line([u(1) u(1)+0.5],[0 0]);
set(h,'LineWidth',[2],'Color',[0 0 0]);
h=line([u(1)+0.5 u(1)+0.5],[-0.3 0.3]);
set(h,'LineWidth',[2],'Color',[0 0 0]);
h=line([u(1)+2.6 u(1)+0.5],[-0.3 -0.3]);
set(h,'LineWidth',[2],'Color',[0 0 0]);
h=line([u(1)+2.6 u(1)+0.5],[0.3 0.3]);
set(h,'LineWidth',[2],'Color',[0 0 0]);
h=line([2.5 5],[0 0]);
set(h,'LineWidth',[2],'Color',[0 0 0]);
h=line([2.5 2.5],[-0.25 0.25]);
set(h,'LineWidth',[2],'Color',[0 0 0]);
   
%Feder
h=line([-2+u(3) -2+u(3)],[0.5 -0.5]);
set(h,'LineWidth',[2],'Color',[0 0 0]);
h=line([-2+u(3) -2+u(3)+0.2],[0 0]);
set(h,'LineWidth',[2],'Color',[0 0 0]);
h=line([u(1) u(1)-0.2],[0 0]);
set(h,'LineWidth',[2],'Color',[0 0 0]);
Federgaenge=10;
for i=1:Federgaenge
    d=(1.6-u(3)+u(1))/Federgaenge;
    if i==1
        h=line([-1.8+u(3) -1.8+u(3)+d],[0 0.25]);
        set(h,'LineWidth',[2],'Color',[0 0 0]);
    elseif i==Federgaenge
        h=line([-1.8+u(3)+(i-1)*d -1.8+u(3)+i*d],[(-1)^i*0.25 0]);
        set(h,'LineWidth',[2],'Color',[0 0 0]);
    else
        h=line([-1.8+u(3)+(i-1)*d -1.8+u(3)+i*d],[(-1)^i*0.25 (-1)^(i+1)*0.25]);
        set(h,'LineWidth',[2],'Color',[0 0 0]);
    end            
end

%Wand
h=line([5 5],[0.5 -0.5]);
set(h,'LineWidth',[5],'Color',[0 0 0]);

%Federkraft
patch([0 0 5*(u(3)-u(1))], [-1.8 -1.3 -1.5],[0 0 0]);

%Dmpferkraft
patch([3 3 3-5*u(2)], [-1.8 -1.3 -1.5],[0 0 0]);


% end mdlUpdate

%
%=============================================================================
% mdlOutputs
% Return the block outputs.
%=============================================================================
%
function sys=mdlOutputs(t,x,u)

sys = [];

% end mdlOutputs

%
%=============================================================================
% mdlGetTimeOfNextVarHit
% Return the time of the next hit for this block.  Note that the result is
% absolute time.
%=============================================================================
%
function sys=mdlGetTimeOfNextVarHit(t,x,u)

sys = [];

% end mdlGetTimeOfNextVarHit

%
%=============================================================================
% mdlTerminate
% Perform any end of simulation tasks.
%=============================================================================
%
function sys=mdlTerminate(t,x,u)

sys = [];

% end mdlTerminate