function plotPolynomial(obj,pointsPerAxis,figHandle)

if nargin < 2
    figure
    pointsPerAxis = 25;
elseif nargin < 3
    figure
else
    figure(figHandle)
end
inputDimension = size(obj.exponent,2);

if inputDimension == 1
    x = linspace(0,1,pointsPerAxis)';
    y = obj.calculateOutput(x);
    plot(x,y,'o-','LineWidth',1.5,'MarkerSize',13)
elseif inputDimension == 2
    [X1,X2] = meshgrid(linspace(0,1,pointsPerAxis));
    x = [X1(:) X2(:)];
    y = obj.calculateOutput(x);
    surf(X1,X2,reshape(y,pointsPerAxis,pointsPerAxis))
    
elseif inputDimension == 3
    [X1,X2,X3] = meshgrid(linspace(0,1,pointsPerAxis));
    x = [X1(:) X2(:) X3(:)];
else
    error
end
