% Test different Complexities in Dimensions
close all


figure
for ii=1:9
    rng(1)
    expVec=linspace(0,1,9);
    numTermsVec=ceil(linspace(8,8,9));
    a=randomPolynomial(2,[8 numTermsVec(ii)],[1 expVec(ii)]);
    
    u1=rand(10000,1);
    u2=rand(10000,1);
    
    [U1,U2]=meshgrid(linspace(0,1,40));
    u1=U1(:);
    u2=U2(:);
    
    out = a.calculateOutput([u1,u2]);
    
    tri=delaunay(u1,u2);
    subplot(3,3,ii)
    trimesh(tri,u1,u2,out)
    xlabel('u_1')
    ylabel('u_2')
    zlabel('y')
end

figure
for ii=1:9
    rng(1)
    expVec=linspace(1,1,9);
    numTermsVec=ceil(linspace(1,8,9));
    a=randomPolynomial(2,[8 numTermsVec(ii)],[1 expVec(ii)]);
    
    u1=rand(10000,1);
    u2=rand(10000,1);
    
    [U1,U2]=meshgrid(linspace(0,1,40));
    u1=U1(:);
    u2=U2(:);
    
    out = a.calculateOutput([u1,u2]);
    
    tri=delaunay(u1,u2);
    subplot(3,3,ii)
    trimesh(tri,u1,u2,out)
    xlabel('u_1')
    ylabel('u_2')
    zlabel('y')
end

