%% Generate random polynomials

clc;
close all;
clear;

%% Settings
numberOfDifferentPolynomials = 3;
numberOfInputs = 2;
numberOfTerms = 10;         % default value: 10
meanExpoDist = 1.5;         % default value: 1.5
type = 'sigmoid';           % 'poly', 'sigmoid' or 'sine'

visualizePolynomials = true; % only for 2-dimensional input space possible
saveRandomFunctions = false;
seedFunctionGenerator = false;

% Generate two random seedings that will be used to generate the
% polynomials
if seedFunctionGenerator
    rng(24,'twister');
end

% Generate seedings
seedings = round(rand(1,numberOfDifferentPolynomials)*(numberOfDifferentPolynomials*50-1))+1;
seedings = unique(seedings);

% Make sure all no seeding occurs more than once
while size(seedings,2) < numberOfDifferentPolynomials
    seedings = [seedings round(rand(1,numberOfDifferentPolynomials)*(numberOfDifferentPolynomials*50-1))+1];
    seedings = unique(seedings);
end
seedings = seedings(1:numberOfDifferentPolynomials);

%% Generate Polynomials
% Pre-define variable, that will contain the polynomials
polynomials = cell(1,numberOfDifferentPolynomials);

for ii=1:numberOfDifferentPolynomials
    
    % Set seeding for random generator
    rng(seedings(ii),'twister');
    
    % Generate polynomial
    polynomials{1,ii} = randomPolynomial(numberOfInputs,numberOfTerms,meanExpoDist,type);
    
    % Visualization of polynomials
    if visualizePolynomials && numberOfInputs == 2
        if ii==1
            % Generate input data
            Ngrid = 25;
            [u1g,u2g] = meshgrid(linspace(0,1,Ngrid));
            uPlot = [u1g(:) u2g(:)];
        end
        
        % Calculate output of current randomly generated function
        yPlot = polynomials{1,ii}.calculateOutput(uPlot);
        yG = reshape(yPlot,Ngrid,Ngrid);
        
        figure;
        surf(u1g,u2g,yG);
        xlabel('u_1');
        ylabel('u_2');
        zlabel('y');
        
    end
    
end

if saveRandomFunctions
    % Save polynomials
    savename = [type,'Polynomials_',num2str(numberOfInputs),...
        'inputs_',num2str(numberOfTerms),'terms_meanExpo',num2str(meanExpoDist),'.mat'];
    save(savename,'numberOfInputs','numberOfTerms','meanExpoDist','polynomials');
end
