classdef randomPolynomial
    %% RANDOMPOLYNOMIAL is used to generate a random polynomial functions.
    %
    % RANDOMPOLYNOMIAL class generates and stores polynomials of arbitrary
    % dimension p with few cross terms. The number of polynomial
    % terms is also arbitrary. Their coefficients (factors) are
    % chosen according to a normal distribution (mean 0, variance 1). Key is
    % the generation of the powers pow_1,pow_2,...,pow_p for each input within
    % each term. They are chosen according to a exponential distribution with
    % specific mean. For pow_i=0 the corrsponding input is irrelevant for
    % the considered term.
    %
    %
    %   REGRESSOR properties:
    %
    %       exponent - (t x p) Exponent matrix containing the exponents of
    %                          the inputs for each polynomial term
    %                          (default: []).
    %
    %       coefficients - (t x 1) Coefficient for each polynomial term
    %                              (default: []).
    %
    %       shift   - (p x 1) Shift for each input dimension
    %                         (default: []).
    %       
    %
    %
    %   EXPLANATIONS:
    %
    %       "exponent": Contains the exponent of the p inputs for each
    %       t polynmial term.
    %
    %       "coefficients": Contains coefficient of the polynomial terms.
    %
    %       "shift": Contains a shift for each input dimension. That avoids
    %       the origin.
    %
    %       "type": string indicates which type of function should be
    %       generated. Possible choices are:
    %       <poly> - simple polynimial. (default)
    %       <sigmoid> - sigmoid function with polynomial as input.
    %       <sine> - Each polynomial term used as input for a sine before superposition of terms.
    %
    %
    %
    %   SYMBOLS AND ABBREVIATIONS
    %
    %       p:   Number of inputs (physical inputs)
    %       N:   Number of data samples
    %       t:   Number of polynomial terms
    %
    %
    %   LMNtool - Local Model Network Toolbox
    %   Torsten Fischer, 18-DEcember-2014
    %   Institute of Mechanics & Automatic Control, University of Siegen, Germany
    %   Copyright (c) 2014 by Prof. Dr.-Ing. Oliver Nelles
    
    properties
        exponent = [];
        coefficients = [];
        shift = [];
        outputRange = [];
        globalOptSigmaRange = [];
        globalOptCovariance = [];
        globalOptCenter = [];
        type = 'poly';
        meanExpoDist = [];
    end
    
    
    methods
        function obj = randomPolynomial(inputDimension, numberOfTerms, meanExpoDist,type)
            if nargin == 0
                warning('randomPolynomial:constructor','No variables are given! The object properties are empty! To use the object, you have to to call the function <functionGenerator> manually!')
            else
                if nargin < 2
                    numberOfTerms = 10;
                end
                if nargin < 3
                    meanExpoDist = 1.5;
                end
                if nargin < 4
                    type = obj.type;
                end
                obj = obj.functionGenerator(inputDimension, numberOfTerms, meanExpoDist,type);
            end
        end
    end
end
